#ifndef __FUNCTION_CONTROLS_H__
#define __FUNCTION_CONTROLS_H__

#include <stdbool.h>

struct Quaternion;
struct Vector;

void FunctionControls_init();
bool FunctionControls_mouseDown(int x, int y);
void FunctionControls_mouseUp(int x, int y);
void FunctionControls_mouseDragged(int x, int y);
void FunctionControls_draw();

void FunctionControls_setEditFieldValue(float value);
float FunctionControls_getEditFieldValue();

void FunctionControls_setMultiplyQuaternion(struct Quaternion quaternion);
struct Quaternion FunctionControls_multiply(struct Quaternion quaternion);
void FunctionControls_setSLERPQuaternion(struct Quaternion quaternion);
struct Quaternion FunctionControls_slerp(struct Quaternion quaternion);
void FunctionControls_setRotateAxisAngle(struct Vector axis, float angle);
struct Quaternion FunctionControls_rotate(struct Quaternion quaternion);

#endif
